// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>
#include <string>
#include <map>
#include <set>
#include <queue>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cout << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long llint;

int main(void) {
  char buff[222];
  scanf("%s", buff);

  string inventory = buff;
  map<char, string> rules;
  int m;
  scanf("%d", &m);
  REP(i, m) {
    scanf("%s", buff);
    rules[buff[0]] = buff+3;
  }

  for (char c = 'a'; c <= 'z'; ++c) {
    multiset<char> have(inventory.begin(), inventory.end());
    queue<char> need;
    need.push(c);

    bool ok = true;
    while (!need.empty() && need.size() <= have.size()) {
      char x = need.front();
      need.pop();
      
      if (have.count(x)) {
        have.erase(have.find(x));
      } else {
        if (!rules.count(x)) {
          ok = false;
          break;
        }

        for (char c: rules[x]) {
          need.push(c);
        }
      }
    }

    if (ok && need.empty()) putchar(c);
  }
  putchar('\n');
  return 0;
}
